﻿namespace Code6587EN.Ch05.NewPage
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Administration;
    using Microsoft.SharePoint.Publishing;
    using System;
    using System.Linq;

    /// <summary>
    /// Console Application to Create a New a Publishing Page
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Open the Site Collection containing the Site
            using (var site = new SPSite("http://sharepoint/publishing"))
            {
                // Open the Site
                using (var web = site.OpenWeb())
                {
                    // Get the Publishing Site from the SharePoint Site
                    var pubWeb = PublishingWeb.GetPublishingWeb(web);

                    // Get the specified Page Layout from the available layouts
	                var layout = pubWeb.GetAvailablePageLayouts().Where(p => p.Title == "Blank Web Part Page").First();

	                // Create the new Page
	                var page = pubWeb.AddPublishingPage("CodePage.aspx", layout);
	                page.Update();

	                // Set the Title of the Page
	                page.ListItem["Title"] = "Code Page";
                    page.ListItem.Update();
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
